# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 10
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR10_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmony_rebuilder_v3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_score = sum(1 for move in opp_history if move == "C")  # Tracks their gullibility
    
    # Early rounds: build false trust pattern
    if current_round == 1:
        return "C"
    elif current_round == 2:
        return "D"
    elif current_round == 3:
        return "C"
    
    # Mid-game: exploit or confuse based on their response
    if 4 <= current_round <= 7:
        if len(opp_history) >= 3 and opp_history[2] == "C":
            return "D"  # Exploit their forgiveness
        else:
            return "C" if current_round % 2 == 0 else "D"  # Alternate to appear unpredictable
    
    # Late game: secure lead or minimize loss
    if current_round >= 8:
        my_score = sum(3 if m == "C" and o == "C" else 
                       (5 if m == "D" and o == "C" else 
                        (0 if m == "C" and o == "D" else 1))
                       for m, o in zip(my_history, opp_history))
        their_score = sum(3 if o == "C" and m == "C" else 
                          (5 if o == "D" and m == "C" else 
                           (0 if o == "C" and m == "D" else 1))
                          for m, o in zip(my_history, opp_history))
        
        if my_score > their_score:
            return "D"  # Secure lead
        elif my_score < their_score:
            return "D"  # Minimize their advantage
        else:
            return "D" if "forgive" in opponent_program_code.lower() else "C"
    
    return "D"  # Fallback to defection